package ch.frankel.blog.hibernate;

import static org.testng.Assert.assertEquals;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.hibernate.Session;
import org.testng.annotations.Test;

import ch.frankel.blog.hibernate.model.Customer;

/**
 * Test class to check some basic truths about Hibernate.
 * 
 * @author Nicolas Frnkel
 * @since 14 juin 2009
 */
public class TestPart1 extends AbstractTest {

    /**
     * Test class for checking whether you need to explicitly call the
     * <code>update()</code> method on a persistent object.
     * 
     * @throws SQLException
     */
    @Test
    public void testUpdateWithoutCall() throws SQLException {

        Session session = factory.getCurrentSession();

        session.getTransaction().begin();

        Customer person = (Customer) session.load(Customer.class, 1L);

        // Change the value without calling update
        person.setLastName("FooBar");

        session.getTransaction().commit();

        long id = person.getId();

        Connection connection = DriverManager.getConnection("jdbc:derby:target/myDb");

        PreparedStatement stmt = connection.prepareStatement("SELECT LAST_NAME FROM CUSTOMER WHERE ID = ?");

        stmt.setLong(1, id);

        ResultSet rs = stmt.executeQuery();

        rs.next();

        String lastName = rs.getString("LAST_NAME");

        connection.close();

        assertEquals(lastName, "FooBar");
    }
}
